Attribute VB_Name = "mod_CEC"
' CEC IEEE-488 subroutines
' for use with CEC interface cards
' Copyright (C) 1995, Capital Equipment Corporation
' Customers may use this code in their application
' programs which run with CEC interface cards.
' All other rights reserved.
' For VISUAL BASIC 4.0 and later versions
'
' revisions:
'       4/23/96 - change integer to long for 32-bit routines
'       ??      - Add SendKI, QueryKI, PollKI, GetAddress, GPIBerror to permit the use of
'                 either CEC, NI, or RS-232 communication to instrument(s)
'                 (NI modules niglobal.bas and vbib-32.bas required for NI GPIB card)
'       8/15/01 - Comment out RS-232 code for 2520 VB Demo (RS-232 is too slow for data trans)
'       8/15/01 - Add BqueryKI for binary data transfer

#If Win32 Then
'----------------------------------------------------------------------------
' 32-bit versions of IEEE488 routines
'----------------------------------------------------------------------------
Declare Sub initialize Lib "IEEE_32M.DLL" Alias "_ieee_initialize@8" (ByVal addr As Long, ByVal level As Long)
Declare Sub IEtrans Lib "IEEE_32M.DLL" Alias "_ieee_transmit@12" (ByVal cmd As String, ByVal l As Long, status As Long)
Declare Sub IEreceive Lib "IEEE_32M.DLL" Alias "_ieee_receive@16" (ByVal r As String, ByVal maxlen As Long, l As Long, status As Long)
Declare Sub IEsend Lib "IEEE_32M.DLL" Alias "_ieee_send@16" (ByVal addr As Long, ByVal s As String, ByVal l As Long, status As Long)
Declare Sub IEenter Lib "IEEE_32M.DLL" Alias "_ieee_enter@20" (ByVal r As String, ByVal maxlen As Long, l As Long, ByVal addr As Long, status As Long)
Declare Sub IEspoll Lib "IEEE_32M.DLL" Alias "_ieee_spoll@12" (ByVal addr As Long, poll As Long, status As Long)
Declare Sub IEppoll Lib "IEEE_32M.DLL" Alias "_ieee_ppoll@4" (poll As Long)
Declare Sub IEtarray Lib "IEEE_32M.DLL" Alias "_ieee_tarray@16" (d As Any, ByVal count As Long, ByVal eoi As Long, status As Long)
Declare Sub IErarray Lib "IEEE_32M.DLL" Alias "_ieee_rarray@16" (d As Any, ByVal count As Long, l As Long, status As Long)
Declare Function srq Lib "IEEE_32M.DLL" Alias "_ieee_srq@0" () As Long
Declare Sub setport Lib "IEEE_32M.DLL" Alias "_ieee_setport@8" (ByVal board As Long, ByVal port As Long)
Declare Sub boardselect Lib "IEEE_32M.DLL" Alias "_ieee_boardselect@4" (ByVal board As Long)
Declare Sub dmachannel Lib "IEEE_32M.DLL" Alias "_ieee_dmachannel@4" (ByVal chan As Long)
Declare Sub settimeout Lib "IEEE_32M.DLL" Alias "_ieee_settimeout@4" (ByVal msec As Long)
Declare Sub setoutputEOS Lib "IEEE_32M.DLL" Alias "_ieee_setoutputEOS@8" (ByVal c1 As Long, ByVal c2 As Long)
Declare Sub setinputEOS Lib "IEEE_32M.DLL" Alias "_ieee_setinputEOS@4" (ByVal c As Long)
Declare Sub Enable488EX Lib "IEEE_32M.DLL" Alias "_ieee_enable_488ex@4" (ByVal e As Long)
Declare Sub Enable488SD Lib "IEEE_32M.DLL" Alias "_ieee_enable_488sd@8" (ByVal e As Long, ByVal t As Long)
Declare Function ListenerPresent Lib "IEEE_32M.DLL" Alias "_ieee_listener_present@4" (ByVal a As Long) As Long
Declare Function GpibBoardPresent Lib "IEEE_32M.DLL" Alias "_ieee_board_present@0" () As Long
#Else
'----------------------------------------------------------------------------
' 16-bit versions of IEEE488 routines
'----------------------------------------------------------------------------
Declare Sub initialize Lib "win488.dll" Alias "IEEE488_INITIALIZE" (ByVal addr As Integer, ByVal level As Integer)
Declare Sub IEtrans Lib "win488.dll" Alias "IEEE488_TRANSMIT" (ByVal cmd As String, ByVal l As Integer, status As Integer)
Declare Sub IEreceive Lib "win488.dll" Alias "IEEE488_RECEIVE" (ByVal r As String, ByVal maxlen As Integer, l As Integer, status As Integer)
Declare Sub IEsend Lib "win488.dll" Alias "IEEE488_SEND" (ByVal addr As Integer, ByVal s As String, ByVal l As Integer, status As Integer)
Declare Sub IEenter Lib "win488.dll" Alias "IEEE488_ENTER" (ByVal r As String, ByVal maxlen As Integer, l As Integer, ByVal addr As Integer, status As Integer)
Declare Sub IEspoll Lib "win488.dll" Alias "IEEE488_SPOLL" (ByVal addr As Integer, poll As Integer, status As Integer)
Declare Sub IEppoll Lib "win488.dll" Alias "IEEE488_PPOLL" (poll As Integer)
Declare Sub IEtarray Lib "win488.dll" Alias "IEEE488_TARRAY" (d As Any, ByVal count As Integer, ByVal eoi As Integer, status As Integer)
Declare Sub IErarray Lib "win488.dll" Alias "IEEE488_RARRAY" (d As Any, ByVal count As Integer, l As Integer, status As Integer)
Declare Function srq Lib "win488.dll" Alias "IEEE488_SRQ" () As Integer
Declare Sub setport Lib "win488.dll" Alias "IEEE488_SETPORT" (ByVal board As Integer, ByVal port As Integer)
Declare Sub boardselect Lib "win488.dll" Alias "IEEE488_BOARDSELECT" (ByVal board As Integer)
Declare Sub dmachannel Lib "win488.dll" Alias "IEEE488_DMACHANNEL" (ByVal chan As Integer)
Declare Sub settimeout Lib "win488.dll" Alias "IEEE488_SETTIMEOUT" (ByVal msec As Integer)
Declare Sub setoutputEOS Lib "win488.dll" Alias "IEEE488_SETOUTPUTEOS" (ByVal c1 As Integer, ByVal c2 As Integer)
Declare Sub setinputEOS Lib "win488.dll" Alias "IEEE488_SETINPUTEOS" (ByVal c As Integer)
Declare Sub Enable488EX Lib "win488.dll" Alias "IEEE488_ENABLE_488EX" (ByVal e As Integer)
Declare Sub Enable488SD Lib "win488.dll" Alias "IEEE488_ENABLE_488SD" (ByVal e As Integer, ByVal t As Integer)
Declare Function ListenerPresent Lib "win488.dll" Alias "IEEE488_LISTENER_PRESENT" (ByVal a As Integer) As Integer
Declare Function GpibBoardPresent Lib "win488.dll" Alias "IEEE488_BOARD_PRESENT" () As Integer
#End If

Global kidev As Integer                             'GPIB address for instrument
Global Abort As Integer
Global Running As Integer
'Global numBytes As Integer

'---------------------------------------
'Comm Control
'---------------------------------------
'Handshaking
Global Const MSCOMM_HANDSHAKE_NONE = 0
Global Const MSCOMM_HANDSHAKE_XONXOFF = 1
Global Const MSCOMM_HANDSHAKE_RTS = 2
Global Const MSCOMM_HANDSHAKE_RTSXONXOFF = 3

'Event constants
Global Const MSCOMM_EV_SEND = 1
Global Const MSCOMM_EV_RECEIVE = 2
Global Const MSCOMM_EV_CTS = 3
Global Const MSCOMM_EV_DSR = 4
Global Const MSCOMM_EV_CD = 5
Global Const MSCOMM_EV_RING = 6
Global Const MSCOMM_EV_EOF = 7

'Error code constants
Global Const MSCOMM_ER_BREAK = 1001
Global Const MSCOMM_ER_CTSTO = 1002
Global Const MSCOMM_ER_DSRTO = 1003
Global Const MSCOMM_ER_FRAME = 1004
Global Const MSCOMM_ER_OVERRUN = 1006
Global Const MSCOMM_ER_CDTO = 1007
Global Const MSCOMM_ER_RXOVER = 1008
Global Const MSCOMM_ER_RXPARITY = 1009
Global Const MSCOMM_ER_TXFULL = 1010

Global Const BRDNUM = 0

'-------------------------------------------------------
Sub enter(r As String, maxlen As Integer, l As Integer, addr As Integer, status As Integer)
#If Win32 Then
    Dim stl As Long
    Dim ll As Long
    r = Space$(maxlen)
    Call IEenter(r, maxlen, ll, addr, stl)
    l = ll
    r = Left$(r, l)
    status = stl
#Else
    r = Space$(maxlen)
    Call IEenter(r, maxlen, l, addr, status)
    r = Left$(r, l)
#End If
End Sub
'-------------------------------------------------------
Sub Receive(r As String, maxlen As Integer, l As Integer, status As Integer)
#If Win32 Then
    Dim stl As Long
    Dim ll As Long
    r = Space$(maxlen)
    Call IEreceive(r, maxlen, ll, stl)
    l = ll
    r = Left$(r, l)
    status = stl
#Else
    r = Space$(maxlen)
    Call IEreceive(r, maxlen, l, status)
    r = Left$(r, l)
#End If
End Sub
'-------------------------------------------------------
Sub CECSend(addr As Integer, s As String, status As Integer)
#If Win32 Then
    Dim stl As Long
    Call IEsend(addr, s, -1, stl)
    status = stl
#Else
    Call IEsend(addr, s, -1, status)
#End If
End Sub
'-------------------------------------------------------
Sub transmit(cmd As String, status As Integer)
#If Win32 Then
    Dim stl As Long
    Call IEtrans(cmd, -1, stl)
    status = stl
#Else
    Call IEtrans(cmd, -1, status)
#End If
End Sub
'-------------------------------------------------------
Sub spoll(ByVal addr As Integer, poll As Integer, status As Integer)
#If Win32 Then
    Dim stl As Long
    Dim pl As Long
    Call IEspoll(addr, pl, stl)
    poll = pl
    status = stl
#Else
    Call IEspoll(addr, poll, status)
#End If
End Sub
'-------------------------------------------------------
Sub Ppoll(poll As Integer)
#If Win32 Then
    Dim pl As Long
    Call IEppoll(pl)
    poll = pl
#Else
    Call IEppoll(poll)
#End If
End Sub
'-------------------------------------------------------
' IMPORTANT NOTE:
'       To call tarray and rarray in VB 4, you must pass the
'       entire array, as in:
'               call tarray(d(),100,1,status%)
'       You CANNOT pass d(1), as was done in previous versions
'       of VB.  Microsoft changed the data types and argument
'       conventions, so this source code change is required.
'
' IMPORTANT NOTE: If you want to use arrays of a type other than
'       integer, you must edit these procedures and change the
'       type of the local array dd() in both tarray and rarray.
'       Also, you must change the loop limit variable yy.
'       For example, to use Byte arrays, change the dim statements to:
'               dim dd(65535) as byte
'       and the statement just before the "for xx" loops to:
'               yy = count
'       and
'               yy = l
Sub tarray(d As Variant, ByVal count As Long, ByVal eoi As Integer, status As Integer)
    Dim dd(32767) As Integer
#If Win32 Then
    Dim stl As Long
    If (count And 1) = 0 Then yy = count / 2 Else yy = count / 2 + 1
    For xx = 1 To yy: dd(xx) = d(xx): Next xx
    Call IEtarray(dd(1), count, eoi, stl)
    status = stl
#Else
    If (count And 1) = 0 Then yy = count / 2 Else yy = count / 2 + 1
    For xx = 1 To yy: dd(xx) = d(xx): Next xx
    Call IEtarray(dd(1), count, eoi, status)
#End If
End Sub
'-------------------------------------------------------
' IMPORTANT NOTE:
'       To call tarray and rarray in VB 4, you must pass the
'       entire array, as in:
'               call tarray(d(),100,1,status%)
'       You CANNOT pass d(1), as was done in previous versions
'       of VB.  Microsoft changed the data types and argument
'       conventions, so this source code change is required.
'
Sub rarray(d As Variant, ByVal count As Long, l As Integer, status As Integer)
    Dim dd(32767) As Integer
#If Win32 Then
    Dim stl As Long
    Dim ll As Long
    Call IErarray(dd(1), count, ll, stl)
    l = ll
    status = stl
#Else
    Call IErarray(dd(1), count, l, status)
#End If
    If (l And 1) = 0 Then yy = l / 2 Else yy = l / 2 + 1
    For xx = 1 To yy: d(xx) = dd(xx): Next xx
End Sub

'Sub EnableEvents()
'    commset.GPIBAddress.Enabled = True
'    commset.GPIBCommands.Enabled = True
'    commset.SendCmd.Enabled = True
'    commset.GetResponse.Enabled = True
'    commset.DispCmd.Enabled = True
'    commset.DDCMode.Enabled = True
'    commset.SaveSettings.Enabled = True
'    commset.DataPathSelect.Enabled = True
'    commset.ComPortSelect.Enabled = True
'    commset.BaudRateSelect.Enabled = True
'    commset.DataBitsSelect.Enabled = True
'    commset.StopBitsSelect.Enabled = True
'    commset.ParitySelect.Enabled = True
'    commset.SendGet.Enabled = True
'    If commset.DDCMode.value = False Then
'        commset.GetErr.Enabled = True
'        commset.DisableDisplay.Enabled = True
'        commset.NextCalCmd.Enabled = True
'    End If
'    Running = False
'    commset.ExitButton.Caption = "Exit"
'    commset.GPIBCommands.SetFocus
'End Sub
'
'Function GetAddress() As Integer
'    Abort = False
'    If (frmGPIBSettings.CommOpt(0).value) Or (frmGPIBSettings.CommOpt(1).value) Then
'        kidev = Val(frmGPIBSettings.GPIBAddress.Text)
'        If kidev < 0 Or kidev > 30 Then
'            MsgBox "Invalid GPIB Address!" + Chr$(10) + "Must be from 0-30!", 48, "Bad GPIB Address"
'            GetAddress = True
''            frmGPIBSettings.GPIBAddress.Text = "27"
'            Exit Function
'        End If
'        If frmGPIBSettings.CommOpt(0).value Then
'            Call setport(Val(frmGPIBSettings.GPIBbrd.Text), Val(frmGPIBSettings.GPIBioaddr.Text))
'        End If
'    Else
'        For X% = 0 To 9
'            If commset.BaudRate(X%).value Then
'                ComSet$ = commset.BaudRate(X%).Caption + ","
'            End If
'        Next X%
'        For X% = 0 To 2
'            If commset.Parity(X%).value Then
'                ComSet$ = ComSet$ + Left$(commset.Parity(X%).Caption, 1) + ","
'            End If
'        Next X%
'        For X% = 0 To 1
'            If commset.DataBits(X%).value Then
'                ComSet$ = ComSet$ + commset.DataBits(X%).Caption + ","
'            End If
'        Next X%
'        For X% = 0 To 1
'            If commset.StopBits(X%).value Then
'                ComSet$ = ComSet$ + commset.StopBits(X%).Caption
'            End If
'        Next X%
'        For X% = 0 To 3
'            If commset.ComPort(X%).value Then
'                port% = X% + 1
'            End If
'        Next X%
'        If ComSet$ <> commset.Comm1.Settings Then
'            commset.Comm1.Settings = ComSet$
'        End If
'        If commset.Comm1.CommPort <> port% Then
'            If commset.Comm1.PortOpen Then
'                commset.Comm1.PortOpen = False
'            End If
'            commset.Comm1.CommPort = port%
'        End If
'        If Not commset.Comm1.PortOpen Then
'            commset.Comm1.PortOpen = True
'        End If
'    End If
'
'    Running = True
'    GetAddress = False
'    commset.GPIBAddress.Enabled = False
'    commset.GPIBCommands.Enabled = False
'    commset.SendCmd.Enabled = False
'    commset.GetResponse.Enabled = False
'    commset.DispCmd.Enabled = False
'    commset.DDCMode.Enabled = False
'    commset.SaveSettings.Enabled = False
'    commset.DataPathSelect.Enabled = False
'    commset.ComPortSelect.Enabled = False
'    commset.BaudRateSelect.Enabled = False
'    commset.DataBitsSelect.Enabled = False
'    commset.StopBitsSelect.Enabled = False
'    commset.ParitySelect.Enabled = False
'    commset.GetErr.Enabled = False
'    commset.DisableDisplay.Enabled = False
'    commset.NextCalCmd.Enabled = False
'    commset.SendGet.Enabled = False
'    commset.ExitButton.Caption = "STOP"
'    DoEvents
'End Function
'
'Function GPIBError(Msg1$, Msg2$) As Integer
'    Response = MsgBox(Msg1$ + Chr(10) + Msg2$ + Chr(10) + "Select OK to continue program or CANCEL to abort.", 1, "GPIB Error")
'
'    GPIBError = False
'    If Response = 1 Then
'        If (frmGPIBSettings.CommOpt(0).value) Then
'            Call initialize(21, 0)          ' CEC at IEEE address 21
'            Call setoutputEOS(10, 0)        ' Set Output Terminator to LF^EOI
'            Call setinputEOS(10)            ' Set Input Terminator to LF^EOI
'            Call settimeout(1000)           ' Timeout of 1 seconds
''        Else
''            Call SendIFC(BRDNUM)
''            Call ibtmo(BRDNUM, T1s)
'        End If
'        TimeOutError = True
'    ElseIf Response = 2 Then
'        GPIBError = True
'        Abort = True
'        Call EnableEvents
'    End If
'End Function
'
'Function PollKI()
'    Dim poll As Integer
'    Dim status As Integer
'
'    If (commset.CommOpt(0).value) Then
'        spoll kidev, poll, status
'        If status <> 0 Then
'            If GPIBError("GPIB Timeout Error on serial polling the Unit at address: " + CStr(kidev), "") Then Exit Function
'        End If
'    ElseIf (commset.CommOpt(1).value) Then
'        ReadStatusByte 0, kidev, poll
'        If (ibsta And (ERR_488 Or TIMO)) <> 0 Then
'            If GPIBError("GPIB Timeout Error on serial polling the Unit at address: " + CStr(kidev), "") Then Exit Function
'        End If
'    Else
'        If commset.Comm1.InBufferCount Then
'            poll = 16
'        End If
'    End If
'    PollKI = poll
'End Function
'
'Function QueryKI(kidev As Integer) As String
'    Dim length As Integer
'    Dim status As Integer
'    Dim Resp As String
'
''Comment out all RS-232 code, as it's not implemented for the 2520 Demo
''    If (commset.CommOpt(2).value) Then
''        ' Read data.
''        commset.Comm1.InputLen = 0
''        Resp$ = ""
''        Do
''            Resp$ = Resp$ + commset.Comm1.Input
''            DoEvents
''            If Abort Then
''                QueryKI = Resp$
''                Exit Function
''            End If
''        Loop Until Len(Resp$) >= 1024 Or Right$(Resp$, 1) = Chr$(10) Or Right$(Resp$, 1) = Chr$(13)
''        If (Right$(Resp$, 1) = Chr$(10) Or Right$(Resp$, 1) = Chr$(13)) And Len(Resp$) > 1 Then
''            Resp$ = Left$(Resp$, Len(Resp$) - 1)
''        End If
''    ElseIf (commset.CommOpt(0).value) Then
'
'    If (frmGPIBSettings.CommOpt(0).value) Then              'CEC card is used
'        enter Resp, 4096, length, kidev, status
'        If status <> 0 Then
'            a% = GPIBError("GPIB Timeout Error on querying Unit!", "")
'        End If
'    Else                                            'NI card is used
'        Resp$ = Space$(4096)
'        NIReceive BRDNUM, kidev, Resp, LF
'        If (ibsta And (ERR_488 Or TIMO)) <> 0 Then
'            a% = GPIBError("GPIB Timeout Error on querying Unit!", "")
'        End If
'    End If
'    QueryKI = Resp
'End Function
'
'Function SendKI(kidev As Integer, cmd As String) As Integer
''Procedure is a "wrapper" for the send command for CEC, NI, RS-232 communication
'' was Function SendKI(cmd As String) As Integer
''8/15/01 RS-232 (Comm1) commented out, not appropriate for 2520 Demo
'
'    Dim status As Integer
'
'    SendKI = False
'    If (frmGPIBSettings.CommOpt(0).value) Then
'        CECSend kidev, cmd, status
'        If status <> 0 Then
'            SendKI = GPIBError("Timeout on sending data to the Unit:", cmd)
'        End If
'    ElseIf (frmGPIBSettings.CommOpt(1).value) Then
'        NISend BRDNUM, kidev, cmd, NLend
'        If (ibsta And (ERR_488 Or TIMO)) <> 0 Then
'            SendKI = GPIBError("Timeout on sending data to the Unit:", cmd)
'        End If
'    Else
'        If Len(cmd) > 1 Then
'            If Left$(cmd, 1) <> Chr$(10) Then
'                cmd = cmd + Chr$(10)
'            End If
'        End If
''        frmGPIBSettings.Comm1.Output = cmd
''        Do
''            DoEvents
''            If Abort Then Exit Function
''        Loop Until commset.Comm1.OutBufferCount = 0
'    End If
'End Function
'
'Function RecSetupKI(kidev As Integer) As Integer
''Procedure is a "wrapper" for the Receive Setup (config instrument to talk)
''for the CEC and NI GPIB cards
'
'Dim status As Integer
'
'RecSetupKI = False
'If (frmGPIBSettings.CommOpt(0).value) Then
''    transmit , cmd, status
'    Call transmit("UNT UNL MLA TALK " & Str$(kidev), status)   ' Address instrument to talk
'    If status <> 0 Then
'        RecSetupKI = GPIBError("Timeout on sending data to the Unit:", "UNT UNL MLA TALK")
'    End If
'ElseIf (frmGPIBSettings.CommOpt(1).value) Then
''    NISend BRDNUM, kidev, cmd, NLend
'    Call ReceiveSetup(BRDNUM, kidev)                            'Set up instrument to talk, GPIB board is listening
'    If (ibsta And (ERR_488 Or TIMO)) <> 0 Then
'        RecSetupKI = GPIBError("Timeout on sending data to the Unit:", "ReceiveSetup()")
'    End If
'End If
'
'End Function
'
'Public Sub RecBinaryKI(data As Single, numBytes As Long, length As Integer)
''Procedure is a "wrapper" for receiving data in binary (byte) form from the instrument
''for the CEC and NI GPIB cards
''Global:
''       sngTempArray
'
'Dim status As Long
'Dim leng As Long
''Dim intstatus As Integer
''Dim count As Long
'
''count = numBytes
'If (frmGPIBSettings.CommOpt(0).value) Then                  'if CEC, use CEC commands
'    Call IErarray(data, 2, leng, status)       ' Read "#0" from binary string
'    If (status And 8) Then Stop                          ' Check for timeout
'    Call IErarray(data, numBytes, leng, status)  'Retrieve binary data
'    If (status And 8) Then GoTo Err                      'Check for timeout
'
'    ElseIf (frmGPIBSettings.CommOpt(1).value) Then          'NI, so use NI commands
'        Call RcvRespMsg32(intGPIB, data, 2, STOPend) ' Read "#0" from binary string
'        If (status > 16383) Then Stop                           'Check for timeout(=16384)
'        Call RcvRespMsg32(intGPIB, data, numBytes, STOPend) 'Retrieve binary data
'        If (status > 16383) Then GoTo Err                    'Check for timeout(=16384)
'End If
'
'length = leng                               'Return actual (returned) length
'
'Exit Sub
'
'Err:
''Add Error handling code here
'MsgBox "Error during binary transfer"
'
'End Sub
'
'Public Function RecUndoKI(kidev As Integer) As Integer
''Procedure is a "wrapper" for resetting the instrument from a talk (& GPIB card receive) setup
''for the CEC and NI GPIB cards
'
'Dim status As Integer
'
'RecUndoKI = False
'If (frmGPIBSettings.CommOpt(0).value) Then              'CEC board
'    Call transmit("UNT UNL", status)                 'Stop instrument talking, GPIB from listening
'    If (intstatus And 8) Then GoTo Err                  'Check for timeout
'    ElseIf (frmGPIBSettings.CommOpt(1).value) Then      'NI board
'        Call SendIFC(intGPIB)                           'stop talking by sending InterFaceClear (IFC) command
'        If (status > 16383) Then GoTo Err               'Check for timeout(=16384)
'End If
'
'Exit Function
'
'Err:
''Add Error handling code here
'MsgBox "Error during binary transfer"
'
'End Function
